<?php
/**
 * Plugin Name:       Bento Grid 5
 * Description:       A beautiful, responsive 5-item Bento grid layout block with full customization capabilities.
 * Version:           0.1.0
 * Requires at least: 6.0
 * Requires PHP:      7.4
 * Author:            WordPress Telex
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       bento-grid-5-block-wp
 *
 * @package BentoGrid5
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Registers the block using the metadata loaded from the `block.json` file.
 * Behind the scenes, it registers also all assets so they can be enqueued
 * through the block editor in the corresponding context.
 *
 * @see https://developer.wordpress.org/reference/functions/register_block_type/
 */
function bento_grid_5_block_init() {
	register_block_type( __DIR__ . '/build/' );
}
add_action( 'init', 'bento_grid_5_block_init' );

/**
 * Register custom block category for Bento layouts
 */
function bento_grid_5_block_categories( $categories ) {
	return array_merge(
		$categories,
		array(
			array(
				'slug'  => 'bento-layouts',
				'title' => __( 'Bento Layouts', 'bento-grid-5-block-wp' ),
			),
		)
	);
}
add_filter( 'block_categories_all', 'bento_grid_5_block_categories' );
